<?php
namespace ElementorMenu42\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

trait MenuContentTrait {

  private function register_controls_content(): void {
    $this->start_controls_section(
      'section_content_menu',
      [
        'label' => __( 'Content', ELEMENTOR_MENU42_SLUG ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'menu_source',
      [
        'label' => __( 'Select Menu', ELEMENTOR_MENU42_SLUG ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => $this->get_menus(),
      ]
    );

    $this->add_control(
      'submenu-arrow-down',
      [
        'label' => __( 'Submenu arrow down', ELEMENTOR_MENU42_SLUG ),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
          'value' => 'fas fa-chevron-down',
          'library' => 'solid',
        ],
      ]
    );

    $this->add_control('submenu-arrow-right',
      [
        'label' => __( 'Submenu arrow right', ELEMENTOR_MENU42_SLUG ),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
          'value' => 'fas fa-chevron-right',
          'library' => 'solid',
        ],
      ]
    );

    $this->end_controls_section();

    /**
     * Section for repeater buttons
     */
    $this->start_controls_section(
      'section_content_menu_repeater',
      [
        'label' => __( 'Tools', ELEMENTOR_MENU42_SLUG ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );

    $repeater = new \Elementor\Repeater();
    $repeater->add_control(
      'text_field',
      [
        'label' => __( 'Texte', ELEMENTOR_MENU42_SLUG ),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'dynamic' => [
          'active' => true,
        ],
        'default' => __( 'Lorem ipsum', ELEMENTOR_MENU42_SLUG ),
        'placeholder' => __( 'Entrez votre texte', ELEMENTOR_MENU42_SLUG ),
      ]
    );

    $repeater->add_control(
      'link',
      [
        'label' => __( 'Lien', ELEMENTOR_MENU42_SLUG ),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __( 'https://votrelien.com', ELEMENTOR_MENU42_SLUG ),
        'default' => [
          'url' => '#',
        ],
      ]
    );

    // Icon
    $repeater->add_control(
      'icon',
      [
        'label' => __( 'Icône', ELEMENTOR_MENU42_SLUG ),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
          'value' => 'fas fa-user',
          'library' => 'solid',
        ],
      ]
    );

    // Select button type for style
    $repeater->add_control(
      'button_type',
      [
        'label' => __( 'Type de bouton', ELEMENTOR_MENU42_SLUG ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'primary',
        'options' => [
          'primary' => __( 'Primaire', ELEMENTOR_MENU42_SLUG ),
          'secondary' => __( 'Secondaire', ELEMENTOR_MENU42_SLUG ),
          'tertiary' => __( 'Tertiaire', ELEMENTOR_MENU42_SLUG ),
        ],
      ]
    );

    $this->add_control(
      'tools',
      [
        'label' => __( 'Boutons', ELEMENTOR_MENU42_SLUG ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
        ],
        'title_field' => '{{{ text_field }}}',
        'prevent_empty' => false,
      ]
    );

    $this->end_controls_section();
  }

  /**
   * Get WordPress menus
   */
  private function get_menus(): array {
    $menus = wp_get_nav_menus();
    $options = [];

    foreach ( $menus as $menu ) {
      $options[ $menu->slug ] = $menu->name;
    }

    return $options;
  }
}