

class menuWorker {

    /**
     * The element.
     * @type {HTMLElement}
     */
    element;

    /**
     * Elementor menu widget
     * @type {Element | null}
     */
    menu;

    /**
     * Loaded?
     * @type {boolean}
     */
    loaded = false;

    /**
     * Breakpoint for mobile menu
     * @type {number}
     */
    breakpoint = 1500;

    /**
     * @constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
        this.menu = this.element.closest('.elementor-widget-elementor-menu42-menu');
        this.init();
        this.listenEvents();
    }

    /**
     * Init.
     */
    init() {
        this.element.classList.add('loaded');
        this.menu.classList.add('loaded');
        // Remove style display:none
        this.menu.style.display = '';
        this.element.querySelectorAll('.loading').forEach((item) => {
            item.classList.remove('loading');
        });
    }

    listenEvents() {
        // Run function on link click
        const links = this.element.querySelectorAll('a');
        links.forEach((link) => {
            link.addEventListener('click', () => {
                this.linkClick(link);
            });
        });
    }

    linkClick(link) {
        // Check if the link is an anchor, and if yes, close mobile menu
        if (link.href.indexOf('#') !== -1) {
            this.menu?.MenuButton?.closeMenu();
        }
    }

}

/**
 * Load the menu
 */
document.querySelectorAll('.a42__main-menu').forEach((item) => {
    new menuWorker(item);
});