<?php
namespace Brand42\Includes;

if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly.
}

/**
 * Enqueue Assets
 *
 * @package Brand42\Includes
 * @since 1.0.0
 */
class EnqueueAssets {
  public function __construct() {
    // Enqueue admin assets
    add_action('admin_enqueue_scripts', [$this, 'enqueue_admin_assets']);

    // Enqueue admin style for admin bar
    add_action('wp_before_admin_bar_render', [$this, 'enqueue_admin_bar_style']);

    // Enqueue style for login page
    add_action('login_enqueue_scripts', [$this, 'enqueue_login_assets']);
  }

  public function enqueue_admin_assets(): void {
    // Enqueue admin style
    wp_register_style('brand42-admin-style', BRAND42_ASSETS . '/css/admin.css', [], BRAND42_VERSION);
    wp_enqueue_style('brand42-admin-style');

    // Enqueue admin script
    wp_register_script('brand42-admin-script', BRAND42_ASSETS . '/js/admin.js', [], BRAND42_VERSION, true);
    wp_localize_script('brand42-admin-script', 'brand42_ajax', ['url' => admin_url('admin-ajax.php')]);
    wp_enqueue_script('brand42-admin-script');



  }

  public function enqueue_admin_bar_style(): void {
    // Enqueue admin bar style
    wp_register_style('brand42-admin-bar-style', BRAND42_ASSETS . '/css/admin-bar.css', [], BRAND42_VERSION);
    wp_enqueue_style('brand42-admin-bar-style');
  }

  public function enqueue_login_assets(): void {
    // Enqueue login style
    wp_register_style('brand42-login-style', BRAND42_ASSETS . '/css/login.css', [], BRAND42_VERSION);
    wp_enqueue_style('brand42-login-style');

    // Enqueue login script
    wp_register_script('brand42-login-script', BRAND42_ASSETS . '/js/login.js', [], BRAND42_VERSION, true);
    wp_enqueue_script('brand42-login-script');
  }
}