<?php
namespace Brand42\Modules;

if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly.
}

/**
 * Dashboard Widgets Module
 *
 * @package Brand42\Modules\DashboardWidgets
 */
class DashboardWidgets {
  public function __construct() {

    // Add dashboard widgets
    $this->load_dashboard_widgets();
  }

  public function add_dashboard_widgets(): void {
    wp_add_dashboard_widget('brand42_dashboard_widget', 'Brand42 Dashboard Widget', [$this, 'dashboard_widget_content']);
  }

  public function load_dashboard_widgets(): void {
    require __DIR__ . '/base-widget.php';

    require __DIR__ . '/class-contact.php';
    new DashboardWidgets\Contact();

    require __DIR__ . '/class-plugin-updates.php';
    new DashboardWidgets\PluginUpdates();

    require __DIR__ . '/class-stats.php';
    new DashboardWidgets\Stats();

    require __DIR__ . '/class-form-evolution.php';
    new DashboardWidgets\FormEvolution();

    do_action('brand42/load_dashboard_widgets');
  }
}