<?php
namespace Brand42\Modules\DashboardWidgets;

if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly.
}

/**
 * Contact Widget
 *
 * @package Brand42\Modules\DashboardWidgets
 */
class Contact extends DashboardBaseWidget {

  public function get_title(): string {
    return 'Vos contacts rapides';
  }

  public function get_name(): string {
    return 'brand42_contact_widget';
  }

  protected function render(): void {
    $a42_logo = BRAND42_ASSETS . '/img/a42.svg';
    ?>
    <img class="logo" src="<?php echo $a42_logo; ?>" alt="Agence42"/>
    <ul>
      <li>
        <strong>Adresse :</strong>
        <span>371B, rue de Bordeaux
          16000 ANGOULÊME</span>
      </li>
      <li>
        <strong>Téléphone :</strong>
        <a href="tel:0545211312">05 45 21 13 12</a>
      </li>
      <li>
        <strong>Email :</strong>
        <a href="mailto:support@agence42.fr">support@agence42.fr</a>
      </li>
      <li>
        <strong>Site web :</strong>
        <a href="https://agence42.fr" target="_blank">agence42.fr</a>
      </li>
      <li>
        <strong>Horaires :</strong>
        <span>Lundi au vendredi de 9h à 18h</span>
      </li>
    </ul>
    <?php
  }
}