<?php
namespace Brand42\Modules;

if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly.
}

/**
 * Crons Module
 *
 * @package Crons\Modules
 */
class Crons {
  public function __construct() {
    // Add cron schedules
    add_filter('cron_schedules', [$this, 'add_cron_schedules']);
    // Add cron jobs
    $this->load_crons();
  }

  public function load_crons(): void {
    require __DIR__ . '/base-cron.php';

    require __DIR__ . '/class-get-stats.php';
    new Crons\GetStats();

    do_action('brand42/load_crons');
  }

  public function add_cron_schedules($schedules): array {
    $schedules['five_seconds'] = [
      'interval' => 5,
      'display' => 'Every 5 seconds'
    ];
    $schedules['six_hours'] = [
      'interval' => 21600,
      'display' => 'Every 6 hours'
    ];
    return $schedules;
  }
}