<?php
namespace Elementor42\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

trait WooProductMetaRenderTrait {

	protected function render(): void {
		$settings = $this->get_settings_for_display();

		$this->add_render_attribute('wrapper', [
			'class' => 'product-attributes flex flex-column gap-10'
		]);

		$productID = get_the_ID();
		// Get all meta of the product
		$all_meta = get_post_meta( $productID );

		// Get product
		$product = wc_get_product($productID);

		if ( ! $product ) {
			return;
		}
		$attributes = $product->get_attributes();

		$render_attributes = [];

		foreach ($settings['woo_product_meta'] as $meta) {
			$meta_key = $meta['key'];
			$meta_label = $meta['label'];
			$meta_value = $all_meta[$meta_key][0];
			$render_attributes[] = [
				'name' => $meta_label,
				'value' => $meta_value
			];
		}

		foreach ($attributes as $attribute ) {
			if (is_object($attribute)) {
				//console($attribute->get_data());
				$render_attributes[] = $attribute->get_data();
			}
		}



		$this->render_output($settings, $render_attributes);


	}

	protected function render_output(array $settings, array $attributes): void {
		$content = '<ul {{attrs}}>';
		foreach ($attributes as $attribute) {
			$content .= $this->get_render_product_attribute($attribute);
		}
		$content .= '</ul>';

		$map = [
			'{{attrs}}' => $this->get_render_attribute_string('wrapper')
		];

		echo strtr($content, $map);
	}

	private function get_render_product_attribute($item): string {
		$map = [
			'{{attribute_name}}' => $item['name'],
			'{{attribute_value}}' => $item['value'],
		];

		$content = '<li><span class="attr-label">{{attribute_name}} :</span><div class="attr-value">{{attribute_value}}</div></li>';

		return strtr($content, $map);

	}
}