<?php
namespace Elementor42\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

trait WooProductMetaContentTrait {
	/**
	 * Register the content controls
	 */
	private function register_controls_content(): void {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'Content', ELEMENTOR42_SLUG ),
			]
		);

		$meta_repeater = new \Elementor\Repeater();

		// Pick a key from meta list
		$meta_repeater->add_control(
			'key',
			[
				'label' => __( 'Clé', ELEMENTOR42_SLUG ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => $this->get_product_meta_list(),
			]
		);

		// Label
		$meta_repeater->add_control(
			'label',
			[
				'label' => __( 'Label', ELEMENTOR42_SLUG ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => __( 'Entrez votre label', ELEMENTOR42_SLUG ),
			]
		);

		$this->add_control(
			'woo_product_meta',
			[
				'label' => __( 'Meta', ELEMENTOR42_SLUG ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $meta_repeater->get_controls(),
				'title_field' => '{{{ label }}}',
				'prevent_empty' => false,
			]
		);

		$this->end_controls_section();
	}

	private function get_product_meta_list(): array {
		return [
			'_sku' => __( 'SKU', ELEMENTOR42_SLUG ),
			'_price' => __( 'Price', ELEMENTOR42_SLUG ),
			'_regular_price' => __( 'Regular Price', ELEMENTOR42_SLUG ),
			'_sale_price' => __( 'Sale Price', ELEMENTOR42_SLUG ),
			'_weight' => __( 'Weight', ELEMENTOR42_SLUG ),
			'_length' => __( 'Length', ELEMENTOR42_SLUG ),
			'_stock' => __( 'Stock', ELEMENTOR42_SLUG ),
			'_stock_status' => __( 'Stock Status', ELEMENTOR42_SLUG ),
			'_tax_status' => __( 'Tax Status', ELEMENTOR42_SLUG ),
			'_tax_class' => __( 'Tax Class', ELEMENTOR42_SLUG ),
		];
	}
}