<?php
namespace Elementor42\Widgets;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

trait TitleStyleTrait {

  private function register_controls_styles(): void {

    $this->start_controls_section(
      'section_style_title',
      [
        'label' => __( 'Style', ELEMENTOR42_SLUG ),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );

    // Gap
    $this->add_responsive_control(
      'title__gap__top',
      [
        'label' => __( 'Gaps (Espacements)', ELEMENTOR42_SLUG ),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => [ 'px', 'em', 'rem' ],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
          ],
          'em' => [
            'min' => 0,
            'max' => 10,
          ],
          'rem' => [
            'min' => 0,
            'max' => 10,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 10,
        ],
        'selectors' => [
          '{{WRAPPER}} .a42-title-wrapper' => 'gap: {{SIZE}}{{UNIT}};',
        ],
      ]
    );

    /** @note PreTitle */
    $this->add_quick_typography_controls(
      'title__pretitle',
      '.a42-pre_title',
      Global_Colors::COLOR_TEXT,
      Global_Typography::TYPOGRAPHY_PRIMARY,
      __( 'Pré-titre', ELEMENTOR42_SLUG )
    );

    /** @note Title */
    $this->add_quick_typography_controls(
      'title__title',
      '.a42-heading',
      Global_Colors::COLOR_TEXT,
      Global_Typography::TYPOGRAPHY_PRIMARY,
      __( 'Titre', ELEMENTOR42_SLUG )
    );

    /** @note Subtitle */
    $this->add_quick_typography_controls(
      'title__subtitle',
      '.a42-sub_title',
      Global_Colors::COLOR_TEXT,
      Global_Typography::TYPOGRAPHY_PRIMARY,
      __( 'Sous-titre', ELEMENTOR42_SLUG )
    );

    /**
     * Separator Style
     */
    $this->add_control(
      'title__separator__style',
      [
        'label' => __( 'Séparateur', ELEMENTOR42_SLUG ),
        'type' => \Elementor\Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );

    // Width
    $this->add_responsive_control(
      'title__separator__width',
      [
        'label' => __( 'Largeur', ELEMENTOR42_SLUG ),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => [ 'px', '%' ],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 1000,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .a42-title-wrapper:after' => 'width: {{SIZE}}{{UNIT}};',
        ],
      ]
    );

    // Height
    $this->add_responsive_control(
      'title__separator__height',
      [
        'label' => __( 'Hauteur', ELEMENTOR42_SLUG ),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => [ 'px', '%' ],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .a42-title-wrapper:after' => 'height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );

    // Color
    $this->add_control(
      'title__separator__color',
      [
        'label' => __( 'Couleur', ELEMENTOR42_SLUG ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .a42-title-wrapper:after' => 'background: {{VALUE}};',
        ],
      ]
    );

    // Position Before ?
    $this->add_control(
      'title__separator__position_before',
      [
        'label' => __( 'Avant le titre ?', ELEMENTOR42_SLUG ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __( 'Oui', ELEMENTOR42_SLUG ),
        'label_off' => __( 'Non', ELEMENTOR42_SLUG ),
        'return_value' => 'yes',
        'default' => 'yes',
        'selectors' => [
          '{{WRAPPER}} .a42-title-wrapper:after' => 'order: -1;',
        ],
      ]
    );

    /**
     * Underline Style
     */
    $this->add_control(
      'title__underline__style',
      [
        'label' => __( 'Soulignement', ELEMENTOR42_SLUG ),
        'type' => \Elementor\Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );

    // Width
    $this->add_responsive_control(
      'title__underline__width',
      [
        'label' => __( 'Largeur', ELEMENTOR42_SLUG ),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => [ 'px', '%' ],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 1000,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .show-underline:after' => 'width: {{SIZE}}{{UNIT}};',
        ],
      ]
    );

    // Height
    $this->add_responsive_control(
      'title__underline__height',
      [
        'label' => __( 'Hauteur', ELEMENTOR42_SLUG ),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => [ 'px', '%' ],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .show-underline:after' => 'height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );

    // Color
    $this->add_control(
      'title__underline__color',
      [
        'label' => __( 'Couleur', ELEMENTOR42_SLUG ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .show-underline:after' => 'background: {{VALUE}};',
        ],
      ]
    );

    // Position Before ?
    $this->add_control(
      'title__underline__position_after',
      [
        'label' => __( 'Après le titre ?', ELEMENTOR42_SLUG ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __( 'Oui', ELEMENTOR42_SLUG ),
        'label_off' => __( 'Non', ELEMENTOR42_SLUG ),
        'return_value' => 'yes',
        'default' => 'yes',
        'selectors' => [
          '{{WRAPPER}} .show-underline:after' => 'bottom: initial; top: 100%;',
        ],
      ]
    );


    $this->end_controls_section();
  }
}