<?php
namespace Elementor42\Widgets;;

use function Elementor42\Utils\getCssColor;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

trait TitleRenderTrait {

  /**
   * @inheritdoc \Elementor\Widget_Base::render()
   */
  protected function render(): void {
    $settings = $this->get_settings_for_display();

    $this->add_render_attribute('wrapper', 'class', 'a42-title-wrapper flex-column');
    if (!empty($settings['align'])) {
      $this->add_render_attribute('wrapper', 'class', $settings['align']);
    }
    if (!empty($settings['align_mobile'])) {
      $this->add_render_attribute('wrapper', 'class', $settings['align_mobile'] . '-mobile');
    }
    if (!empty($settings['align_tablet'])) {
      $this->add_render_attribute('wrapper', 'class', $settings['align_tablet'] . '-tablet');
    }

    if (!empty($settings['show_bar'] === 'yes')) {
      $this->add_render_attribute('wrapper', 'class', 'show-bar');
    }
    $this->render_output($settings);
  }

  /**
   * Render content
   * If for example 2 keys are type h1, then 2 h1 will be rendered as only one.
   */
  protected function render_output(array $settings): void {
    $titles = $settings['titles'];

    $continuous_types = [ 'h1', 'h2', 'h3', 'span' ];

    ?> <div <?php echo $this->get_render_attribute_string('wrapper'); ?>
      > <?php

      $html = '';
      $last_type = '';
      $opening_tag = '';
    foreach ($titles as $key=>$title) {
      // Get Color
      $color = getCssColor($title);
      // Add color if set
      if ($color) {
        $this->add_render_attribute('title_' . $key, 'style', 'color: ' . $color);
      }

      // If the next title is the same type, then we add a span to the second title (and not closing the first one)
      $next_type = $titles[$key + 1]['type'] ?? '';
      // Open tag
      if ($next_type === $title['type'] && in_array($title['type'], $continuous_types) && $opening_tag === '') {
        $this->add_render_attribute('title_' . $key, 'class', 'a42-heading');
        $opening_tag = $title['type'];
        $html .= '<' . $title['type'] . ' ' . $this->get_render_attribute_string('title_' . $key) . '>';
        $html .= $title['text_field'];
      }
      // Inner tag
      else if ($next_type === $title['type'] && in_array($title['type'], $continuous_types) && $opening_tag !== '') {
        $html .= '<span ' . $this->get_render_attribute_string('title_' . $key) . '>' . $title['text_field'] . '</span>';
      } else if ($next_type !== $title['type'] && $last_type === $opening_tag && $opening_tag !== '') {
        $html .= '<span ' . $this->get_render_attribute_string('title_' . $key) . '>' . $title['text_field'] . '</span>';
        $html .= '</' . $title['type'] . '>';
        $opening_tag = '';
      } else {
        $html .= $this->_render_title($title, $key);
      }

      $last_type = $title['type'];

    }

    echo $html;
    ?> </div> <?php
  }

  /**
   * Render title
   */
  private function _render_title($title, $index): string {

    $type = $title['type'];
    if ($type === 'pre_title' || $type === 'sub_title') {
      $this->add_render_attribute('title_' . $index, 'class', 'a42-' . $type);
      if ($title['show_underline'] === 'yes') {
        $this->add_render_attribute('title_' . $index, 'class', 'show-underline');
      }
      return sprintf('<span %2$s>%1$s</span>',
        $title['text_field'],
        $this->get_render_attribute_string('title_' . $index));
    } else if ($type === 'h1' || $type === 'h2' || $type === 'h3' || $type === 'div' || $type === 'span') {
      $this->add_render_attribute('title_' . $index, 'class', 'a42-heading');
      return sprintf('<%1$s %2$s>%3$s</%1$s>',
        $title['type'],
        $this->get_render_attribute_string('title_' . $index),
        $title['text_field']);
    }

    return '';
  }
}