<?php
namespace Elementor42\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * @Class Ajax Module for Loop42
 * @package Elementor42\Widgets
 * @since 1.0.0
 */
class Loop42Ajax {

	public function __construct() {
		add_action( 'wp_ajax_a42_loop42', [ $this, 'a42_loop42' ] );
		add_action( 'wp_ajax_nopriv_a42_loop42', [ $this, 'a42_loop42' ] );
	}

	/**
	 * Ajax call for the loop42 widget
	 */
	public function a42_loop42(): void {
		$documentId = $_POST['documentId'];
		if ( empty($documentId) ) wp_send_json_error('No post id found:', $documentId);

		$dataId = $_POST['dataId'];
		if ( empty($dataId) ) wp_send_json_error('No data id found:', $dataId);

		$queryPost = json_decode(stripslashes($_POST['query']));
		$document  = \Elementor\Plugin::instance()->documents->get($documentId);
		if ( ! $document ) wp_send_json_error('No document found');

		$element_data = $document->get_elements_data();
		$data = \Elementor\Utils::find_element_recursive( $element_data, $dataId );
		if ( empty( $data ) ) wp_send_json_error('No widget found');


		$vars = get_object_vars( $queryPost );
		foreach ( $vars as $key => $value ) {
			$data['settings'][$key] = $value;
		}

		// Ajax overload is not always working good, so we must change the setting name
		if ( isset( $vars['q_include_term_ids'] ) ) {
			$data['settings']['ajax_q_include_term_ids'] = $vars['q_include_term_ids'];
		}

		// Set the ajax_render to true
		$data['settings']['ajax_render'] = true;

		// Render the widget
		$html = $document->render_element($data);

		// Transform the html to keep only the main content
		// (located between the first and last <main> tags, and remove 'main' tag)
		/*$start = strpos($html, '<main>');
		$end = strrpos($html, '</main>', $start);
		$posts = substr($html, $start + strlen('<main>'), $end - $start - strlen('<main>'));*/

		// Send the html to the client
		wp_send_json_success([
			'posts' => $this->_getHtmlPart($html, '<main>', '</main>'),
			'pagination' => $this->_getHtmlPart($html, '<pagination>', '</pagination>'),
			'query' => $queryPost,
			'data' => $data,
		]);
	}

	/**
	 * Get the part of the html between the start and end tags
	 *
	 * @param $html
	 * @param $startStr
	 * @param $endStr
	 *
	 * @return string
	 */
	private function _getHtmlPart($html, $startStr, $endStr) {
		$start = strpos($html, $startStr);
		$end = strrpos($html, $endStr, $start);
		return substr($html, $start + strlen($startStr), $end - $start - strlen($startStr));
	}
}