<?php
namespace Elementor42\Widgets;

use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

trait LoopFilter42ContentTrait {

	private function register_controls_content(): void {

		$this->start_controls_section(
			'section_content_loop-filter42',
			[
				'label' => __( 'Layout', 'elementor-pro' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		// Filter by taxonomy
		$this->add_control(
			'taxonomy',
			[
				'label' => __( 'Taxonomy', 'elementor-pro' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'category' => __( 'Category', 'elementor-pro' ),
					'tag' => __( 'Tag', 'elementor-pro' ),
					'product_cat' => __( 'Product Category', 'elementor-pro' ),
					'manual_category' => __( 'Manual Selection (category)', 'elementor-pro' ),
					//'author' => __( 'Author', 'elementor-pro' ),
				],
				'default' => 'category',
			]
		);

		// Exclude a taxonomy
		// Will be a SELECT2 based on the taxonomy selected
		$this->add_control(
			'exclude_taxonomy_category',
			[
				'label' => __( 'Exclude', 'elementor-pro' ),
				'type' => Controls_Manager::SELECT2,
				'multiple' => true,
				'options' => $this->get_manual_selection_options('category'),
				'label_block' => true,
				'condition' => [
					'taxonomy' => 'category',
				],
			]
		);

		$this->add_control(
			'exclude_taxonomy_product_cat',
			[
				'label' => __( 'Exclude', 'elementor-pro' ),
				'type' => Controls_Manager::SELECT2,
				'multiple' => true,
				'options' => $this->get_manual_selection_options('product_cat'),
				'label_block' => true,
				'condition' => [
					'taxonomy' => 'product_cat',
				],
			]
		);

		// Filter manual selection
		$this->add_control(
			'filter_category_manual_selection',
			[
				'label' => __( 'Choose items', 'elementor-pro' ),
				'type' => Controls_Manager::SELECT2,
				'multiple' => true,
				'options' => $this->get_manual_selection_options('category'),
				'label_block' => true,
				'condition' => [
					'taxonomy' => 'manual_category',
				],
			]
		);

		// Start level of hierarchy
		$this->add_control(
			'start_level',
			[
				'label' => __( 'Start level', 'elementor-pro' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 0,
				'min' => 0,
				'max' => 6,
				'step' => 1,
			]
		);

		// Show "All" button
		$this->add_control(
			'show_all_button',
			[
				'label' => __( 'Show "All" button', 'elementor-pro' ),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		// Show "All" button
		$this->add_control(
			'all_button_label',
			[
				'label' => __( '"All" button label', 'elementor-pro' ),
				'type' => Controls_Manager::TEXT,
				'default' => 'All',
				'condition' => [
					'show_all_button' => 'yes',
				],
			]
		);

		// Direction
		$this->add_control(
			'direction',
			[
				'label' => __( 'Direction', 'elementor-pro' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'row' => __( 'Row', 'elementor-pro' ),
					'column' => __( 'Column', 'elementor-pro' ),
				],
				'default' => 'row',
			]
		);

		// Allow select multiple
		$this->add_control(
			'allow_select_multiple',
			[
				'label' => __( 'Allow select multiple', 'elementor-pro' ),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
			]
		);

		// Has expandable children ?
		$this->add_control(
			'has_expandable_children',
			[
				'label' => __( 'Has expandable children ?', 'elementor-pro' ),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		// Has scroll ?
		$this->add_control(
			'has_scroll',
			[
				'label' => __( 'Has scroll ?', 'elementor-pro' ),
				'type' => Controls_Manager::SWITCHER,
				'condition' => [
					'direction' => 'row',
				],
				'default' => 'yes',
			]
		);

		// Children arrow icon
		$this->add_control(
			'children_arrow_icon',
			[
				'label' => __( 'Children arrow icon', 'elementor-pro' ),
				'type' => Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-chevron-down',
					'library' => 'solid',
				],
			]
		);

		$this->end_controls_section();
	}

	/**
	 * @param $taxonomy
	 * @return array
	 * Returns the options for the manual selection
	 */
	private function get_manual_selection_options($taxonomy): array {
		// Get all the terms
		$terms = get_terms( [
			'taxonomy' => $taxonomy,
			'hide_empty' => false,
		] );

		// Create the options array
		$options = [];
		foreach ( $terms as $term ) {
			if ( ! is_object( $term ) ) {
				continue;
			}
			$id = $term->term_id;
			$name = $term->name;
			$options[ $id ] = $name;
		}

		return $options;
	}
}