<?php
namespace Elementor42\Widgets;

use Elementor42\Utils\BaseWidget;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * @Class LoopFilter42
 * @package Elementor42\Widgets
 * @since 1.0.0
 */
class LoopFilter42 extends BaseWidget {

	use LoopFilter42ContentTrait;
	use LoopFilter42StyleTrait;
	use LoopFilter42RenderTrait;
	public function get_name() {
		return 'a42-loop-filter42';
	}

	public function get_title() {
		return __( 'A42 Loop Filter', ELEMENTOR42_SLUG );
	}

	public function get_icon() {
		return 'eicon-posts-grid';
	}

	public function get_categories() {
		return [ 'agency42' ];
	}

	public function get_keywords() {
		return [ '42', 'loop', 'posts', 'query', 'filter' ];
	}

	public function get_style_depends() {
		wp_register_style('a42-widget-loop-filter42', ELEMENTOR42_URL . 'assets/css/components/loop-filter42.css', [], ELEMENTOR42_VERSION);
		wp_enqueue_style('a42-widget-loop-filter42');
		return ['anym-utility, a42-widget-loop-filter42'];
	}

	public function get_script_depends() {
		wp_register_script('a42-widget-loop-filter42-script', ELEMENTOR42_URL . 'assets/js/components/loop-filter42.js', ['a42-widget-loop42-script'], ELEMENTOR42_VERSION, true);
		// Insert ajaxurl
		wp_localize_script('a42-widget-loop-filter42-script', 'a42', [
			'ajaxurl' => admin_url('admin-ajax.php'),
		]);
		wp_enqueue_script('a42-widget-loop-filter42-script');
		return ['a42-widget-loop-filter42-script'];
	}

	public function register_controls(): void {
		$this->register_controls_content();
		$this->register_controls_styles();
	}


}