<?php
namespace Elementor42\Modules\ElementorFormFields;

use Elementor\Controls_Manager;
use ElementorPro\Plugin;
use ElementorPro\Modules\Forms\Classes;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Class FieldAcceptance
 *
 * @package Elementor42\Modules\ElementorFormFields
 */
class FieldAcceptance extends \ElementorPro\Modules\Forms\Fields\Field_Base {

	public $depended_scripts = ['a42-field-acceptance-script'];

	public $depended_styles = [];

	public function get_name(): ?string {
		return '[A42] ' . esc_html__( 'Acceptance', 'elementor-pro' );
	}

	public function get_type(): string {
		return 'a42-acceptance';
	}

	public function update_controls( $widget ): void {
		$elementor = Plugin::elementor();

		$control_data = $elementor->controls_manager->get_control_from_stack( $widget->get_unique_name(), 'form_fields' );

		if ( is_wp_error( $control_data ) ) {
			return;
		}

		$field_controls = [
			'a42-acceptance_text' => [
				'name' => 'a42-acceptance_text',
				'label' => esc_html__( 'Acceptance Text', 'elementor-pro' ),
				'type' => Controls_Manager::TEXTAREA,
				'condition' => [
					'field_type' => $this->get_type(),
				],
				'tab' => 'content',
				'inner_tab' => 'form_fields_content_tab',
				'tabs_wrapper' => 'form_fields_tabs',
			],
			'a42-checked_by_default' => [
				'name' => 'a42-checked_by_default',
				'label' => esc_html__( 'Checked by Default', 'elementor-pro' ),
				'type' => Controls_Manager::SWITCHER,
				'condition' => [
					'field_type' => $this->get_type(),
				],
				'tab' => 'content',
				'inner_tab' => 'form_fields_content_tab',
				'tabs_wrapper' => 'form_fields_tabs',
			],
		];

		$control_data['fields'] = $this->inject_field_controls( $control_data['fields'], $field_controls );
		$widget->update_control( 'form_fields', $control_data );
	}

	public function render( $item, $item_index, $form ): void {
        $input_id = 'a42-input' . $item_index;
		$label = '';

        $form->add_render_attribute( $input_id, [
            'class' => 'elementor-acceptance-field a42-validation',
            'type' => 'checkbox',
            'name' => $form->get_attribute_name( $item ),
            'id' => $form->get_attribute_id( $item ),
        ]);

        if ( $item['required'] ) {
            $form->add_render_attribute( $input_id, 'a42required', 'required' );
        }

		if ( ! empty( $item['a42-acceptance_text'] ) ) {
			$label = '<label for="' . $form->get_attribute_id( $item ) . '">' . $item['a42-acceptance_text'] . '</label>';
		}

		if ( ! empty( $item['a42-checked_by_default'] ) ) {
			$form->add_render_attribute( $input_id, 'checked', 'checked' );
		}
        ?>
        <div class="elementor-field-subgroup">
			<span class="elementor-field-option">
				<input <?php $form->print_render_attribute_string($input_id); ?>>
				<?php // PHPCS - the variables $label is safe.
				echo $label; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
			</span>
        </div>
		<?php
	}

	public function validation( $field, $record, $ajax_handler ): void {
		$is_required = $field['required'];
		if ( empty( $field['value'] ) && $is_required ) {
			$ajax_handler->add_error( $field['id'], esc_html__( 'Veuillez accepter les conditions.', ELEMENTOR42_SLUG ) );
		}
	}

	public function process_field($field, Classes\Form_Record $record, Classes\Ajax_Handler $ajax_handler): void {
		$value = $field['value'];
        $niceValue = $value === 'on' ? 'Oui' : 'Non';
		$record->update_field( $field['id'], 'value', $niceValue );
	}

}