<?php
namespace ElementorMenu42\Widgets;

use ElementorMenu42\Utils\BaseWidget;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Class Menu
 *
 * @package ElementorMenu42\ElementorWidgets
 */
class Menu extends BaseWidget {

  use MenuContentTrait;
  use MenuStyleTrait;
  use MenuRenderTrait;

  public function get_name(): string {
    return 'elementor-menu42-menu';
  }

  public function get_title(): ?string {
    return __( '42 Menu', ELEMENTOR_MENU42_SLUG );
  }

  public function get_icon(): string {
    return 'eicon-menu-bar';
  }

  public function get_categories(): array {
    return [ 'agency42' ];
  }

  public function get_keywords(): array {
    return [ '42', 'menu', 'link', 'agence' ];
  }

  public function get_style_depends(): array {
    wp_register_style('a42-widget-menu', ELEMENTOR_MENU42_URL . 'assets/css/components/menu.css', [], ELEMENTOR_MENU42_VERSION);
    wp_register_style('anym-utility', ELEMENTOR_MENU42_URL . 'assets/css/vendors/anym-utility.css', [], ELEMENTOR_MENU42_VERSION);
    return ['a42-widget-menu', 'anym-utility'];
  }

  public function get_script_depends(): array {
    wp_register_script('a42-header-sticky', ELEMENTOR_MENU42_URL . 'assets/js/header-sticky.js', [], ELEMENTOR_MENU42_VERSION, true);
    wp_register_script('a42-scroll-size', ELEMENTOR_MENU42_URL . 'assets/js/scroll-size.js', [], ELEMENTOR_MENU42_VERSION, true);
    wp_register_script('a42-expansion', ELEMENTOR_MENU42_URL . 'assets/js/expansion.js', [], ELEMENTOR_MENU42_VERSION, true);
    wp_register_script('a42-widget-menu-worker', ELEMENTOR_MENU42_URL . 'assets/js/menu-worker.js', [], ELEMENTOR_MENU42_VERSION, true);

    return ['a42-header-sticky', 'a42-scroll-size', 'a42-expansion', 'a42-widget-menu-worker'];
  }

  public function register_controls(): void {
    $this->register_controls_content();
    $this->register_controls_styles();
  }
}