
# Elementor Menu 42

This plugin adds a menu widget to Elementor.




## Usage/Examples

- Create a container in Elementor, add the ElementorMenu42 Widget.
- Add the ID to the container to "main-header"
- Add the class "sticky-top" to the container
- Add the attribute "scrolled-offset-modifier" with a value to the container to set the offset of the scroll position where the size will change.
- Add the attribute "transparent-to-solid" with a value to the container to set the offset of the scroll position where the header will become solid.
- Add the attribute "solid-color" with a value to the container to set the background solid color of the header.
- 
## CSS Customizations

To customize the header heights behaviors, use the css variables :
**Note**: You can also put em inside the elementor custom css section.

```scss
body {
    // Desktop header height
    --header-menu-height: 100px;
    
    // Desktop header mini height
    --header-menu-height-mini: 60px;
    
    // Mobile header height
    --header-menu-height-mobile: 60px;
    
    // Mobile header mini height
    --header-menu-height-mobile-mini: 60px;
    
    // Mobile header mini height (with menu opened)
    --header-menu-height-mobile-opened: var(--header-menu-height-mobile, 60px);
  
    // Padding top of the header (only for desktop, usefull for transparent header)
    --header-padding-top: 0px;
}
```

Other CSS Global variables styles you can use for your theming:

```scss
body {
    // Submenu color
    --submenu-bg-color: #fff;
    
    // Distance of the submenu from the bottom of the header
    --submenu-top-offset: 0px;
}
```