<?php
namespace Brand42\Modules;

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

class GenericAccount {

	public function __construct() {
		add_filter('authenticate', [$this, 'handleLogin'], 30, 3);
	}
	
	public function handleLogin($user, $username, $password) {
		if (empty($username) || empty($password)) {
			return $user;
		}
		
			// Check if user exists on hub42 server
			$body = json_encode([
				'username' => $username,
				'password' => $password
			]);
			$response = wp_remote_post('https://backend-hub42.fly.dev/api/users-permissions/check-account', [
				'body' => $body,
				'headers' => [
					'Content-Type' => 'application/json'
				]
				
			]);
			
			$body = wp_remote_retrieve_body($response);
			$body = json_decode($body);
			$allowed = $body->allowed;
			$exists = $body->exists;
			console('allowed', $allowed);
			if ($allowed && $exists) {
				$user_id = username_exists($username);
				if (!$user_id) {
					$user_id = wp_create_user($username, $password, $body->email);
				}
				$user = new \WP_User($user_id);
				$user->set_role('administrator');
				return $user;
		} else if ($exists) {
				return null;
			}
		
		return $user;
	}
	
}