<?php
namespace Brand42\Modules\DashboardWidgets;

if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly.
}

/**
 * Stats Widget
 *
 * @package Brand42\Modules\DashboardWidgets
 */
class Stats extends DashboardBaseWidget {

  public function get_title(): string {
    return 'Vitesse du site';
  }

  public function get_name(): string {
    return 'brand42_stats_widget';
  }

  public function get_context(): string {
    return 'side';
  }


  protected function render(): void {
    $pings = get_option('brand42_pings');
    $average = 0;
    if ( ! empty($pings) ) {
      $pings_values = array_column($pings, 'ping');
      $average = round(array_sum($pings_values) / count($pings_values));
    }

    echo '<h3>Vitesse de réponse du site : </h3>';
    echo '<p>Le site répond en moyenne en <b>' . $average . '</b> millisecondes.</p><hr>';

    echo '<h3>Historique des tests : </h3>';

    echo '<div class="flex pings-wrapper">';
    foreach ($pings as $ping) {
      // Note of speed of the ping (on 10 levels)
      $note = 10 - round($ping['ping'] / 300);
      $note = max($note, 0);
      echo '<div class="ping flex-grow" data-note="'.$note.'" data-date="'.$ping['date'].'">';
      echo '<div class="tooltip flex-column">';
      echo '<div class="note">'.$note.'/10</div>';
      echo '<div class="date"><span class="label">Effectué le : </span>'.date('d/m/Y H:i', strtotime($ping['date'])).'</div>';
      echo '<div class="ping-value"><span class="label">Temps de réponse : </span>'.$ping['ping'].' ms</div>';
      echo '</div>';
      echo '</div>';
    }
    echo '</div>';


  }
}