<?php
namespace Brand42\Modules;

if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly.
}

/**
 * Module Instancier
 *
 * Require once All modules and instance them
 * Your class must be in a folder with slug name of the class name (CamelCase)
 * @example ClassName in modules/class-name/class-name.module.php
 *
 * @param array $modules - List of modules to load (via their name class)
 *
 * @package Brand42
 */
class ModuleInstancier {
  /**
   * @var array $modules
   * @access public
   * @note Add the modules you want to load here (uncomment)
   */
  private array $modules = [];

  public function __construct($modules) {
    $this->modules = $modules;
    $this->load_modules();
  }

  private function load_modules(): void {
    foreach ($this->modules as $module) {
      // Folder name is the class name in lowercase and replace camel case by dash '-'
      $folder_name = strtolower(preg_replace('/(?<!^)[A-Z]/', '-$0', $module));
      require_once __DIR__ . '/' . $folder_name . '/' . $folder_name . '.module.php';
      $moduleClass = $module;
      // Normalize name to call the class
      $moduleClass = 'Brand42\Modules\\' . $moduleClass;
      new $moduleClass();
    }
  }
}