<?php
namespace Brand42\Modules;

use WP_Roles;

if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly.
}

/**
 * Roles Module
 *
 * @package Roles\Modules
 */
class Roles {
  public function __construct() {

    // Add settings for a42_website_owner_role
    add_action('brand42_register_settings', [$this, 'add_settings']);
    // Add custom roles
    add_action('init', [$this, 'add_custom_roles']);

    // Remove menu items for specific roles
    add_action('admin_menu', [$this, 'remove_menu_items']);

    // On settings saves, reset role
    add_action('update_option_a42_website_owner_role_capabilities', [$this, 'reload_roles']);
  }

  public function add_settings($registrar): void {
    // Capabilities for a42_website_owner_role
    $registrar->add_setting(
      [
        'option' => 'a42_website_owner_role_capabilities',
        'description' => 'Activer les droits pour le rôle de propriétaire du site.',
        'type' => 'checkboxes',
        'label' => 'Rôle de propriétaire du site',
        'options' => [
          'read' => 'Lire',
          'edit_posts' => 'Éditer les articles',
          'delete_posts' => 'Supprimer les articles',
          'publish_posts' => 'Publier les articles',
          'upload_files' => 'Télécharger des fichiers',
          'edit_published_posts' => 'Éditer les articles publiés',
          'delete_published_posts' => 'Supprimer les articles publiés',
          'edit_others_posts' => 'Éditer les articles des autres',
          'delete_others_posts' => 'Supprimer les articles des autres',
          'edit_pages' => 'Éditer les pages',
          'delete_pages' => 'Supprimer les pages',
          'publish_pages' => 'Publier les pages',
          'edit_published_pages' => 'Éditer les pages publiées',
          'delete_published_pages' => 'Supprimer les pages publiées',
          'edit_others_pages' => 'Éditer les pages des autres',
          'delete_others_pages' => 'Supprimer les pages des autres',
          'manage_categories' => 'Gérer les catégories',
          'edit_categories' => 'Éditer les catégories',
          'delete_categories' => 'Supprimer les catégories',
          'manage_links' => 'Gérer les liens',
          'reset_cache' => 'Renouveler le cache',
          'create_users' => 'Créer des utilisateurs',
          'edit_users' => 'Éditer les utilisateurs',
          'delete_users' => 'Supprimer les utilisateurs',
          'list_users' => 'Lister les utilisateurs',
          'promote_users' => 'Promouvoir les utilisateurs',
          'remove_users' => 'Supprimer les utilisateurs',
        ],
        'default' => [
          'read',
          'edit_posts',
          'delete_posts',
          'publish_posts',
          'upload_files',
          'edit_published_posts',
          'delete_published_posts',
          'edit_others_posts',
          'delete_others_posts',
          'edit_pages',
          'delete_pages',
          'publish_pages',
          'edit_published_pages',
          'delete_published_pages',
          'edit_others_pages',
          'delete_others_pages',
          'manage_categories',
          'edit_categories',
          'delete_categories',
          'manage_links',
          'reset_cache',
        ],
      ]
    );

    // Menu items to remove for a42_website_owner_role
    $registrar->add_setting(
      [
        'option' => 'a42_website_owner_role_menu_items',
        'description' => 'Masquer les éléments du menu pour le rôle de propriétaire du site.',
        'type' => 'checkboxes',
        'label' => 'Éléments du menu',
        'options' => [
          'wpseo_workouts' => 'SEO',
          'tools.php' => 'Outils',
          'edit.php?post_type=elementor_library' => 'Elementor Modèles',
          'edit-comments.php' => 'Commentaires',
        ],
        'default' => [
          'wpseo_workouts',
          'tools.php',
          'edit.php?post_type=elementor_library',
          'edit-comments.php',
        ],
      ]
    );

    // SubMenu items to remove for a42_website_owner_role
    $registrar->add_setting(
      [
        'option' => 'a42_website_owner_role_elementor_submenu_items',
        'description' => 'Afficher les éléments du sous-menu pour le rôle de propriétaire du site.',
        'type' => 'checkboxes',
        'label' => 'Éléments du sous-menu de Elementor Modèles',
        'options' => [
          'modeles' => 'Modèles',
          'modals' => 'Modals',
        ],
        'default' => [
          'modeles',
        ],
      ]
    );

    // Remove comments for a42_website_owner_role
    $registrar->add_setting(
      [
        'option' => 'a42_website_owner_role_remove_comments',
        'description' => 'Afficher les commentaires pour le rôle de propriétaire du site.',
        'type' => 'switch',
        'label' => 'Commentaires',
      ]
    );
  }

  public function reload_roles(): void {
    // Remove role if exists
    remove_role('a42_website_owner');

    // Remove role [A42] Propriétaire du site
    $wp_roles = new WP_Roles();
    $roles = $wp_roles->get_names();
    foreach ($roles as $role => $name) {
      if ($name === '[A42] Propriétaire du site') {
        remove_role($role);
      }
    }
    //$this->add_custom_roles();
  }

  public function add_custom_roles(): void {
    $capabilities = get_option('a42_website_owner_role_capabilities');

    // Check if role already exists
    $wp_roles = new WP_Roles();
    //console('roles', $wp_roles->get_names());
    $roles = $wp_roles->get_names();
    if (array_key_exists('a42_website_owner', $roles)) {
      return;
    }

    if (!$capabilities) {
      return;
    }
    $capabilities_values = [];
    foreach ($capabilities as $key => $value) {
      $capabilities_values[$value] = true;
    }


    add_role(
      'a42_website_owner',
      '[A42] Propriétaire du site',
      $capabilities_values
    );
  }

  public function remove_menu_items(): void {
    // Remove comments for a42_website_owner
    if (current_user_can('a42_website_owner')) {
      $remove_comments = get_option('a42_website_owner_role_remove_comments');
      if ($remove_comments !== 'on') {
        remove_menu_page('edit-comments.php');
      }
    }

    // Remove wpseo for a42_website_owner
    if (current_user_can('a42_website_owner')) {
      $menu_items = get_option('a42_website_owner_role_menu_items');
      foreach ($menu_items as $menu_item) {
        remove_menu_page($menu_item);
      }
    }

    $elementor_submenu_items = get_option('a42_website_owner_role_elementor_submenu_items');
    // Remove elementor submenu items for a42_website_owner
    if (current_user_can('a42_website_owner')) {
      if (empty($elementor_submenu_items)) {
        return;
      }
      // Add the menu item
      add_menu_page(
        'Elementor Modèles',
        'Modèles',
        'a42_website_owner',
        'edit.php?post_type=elementor_library&tabs_group=library',
        '',
        'dashicons-editor-table',
        30
      );

      if (in_array('modals', $elementor_submenu_items)) {
        add_submenu_page(
          'edit.php?post_type=elementor_library&tabs_group=library',
          'Elementor Modèles',
          'Modals',
          'a42_website_owner',
          'edit.php?post_type=elementor_library&tabs_group=popup&elementor_library_type=popup'
        );
      }
    }
  }
}