<?php
/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://www.agence42.fr
 * @since             1.0.0
 * @package           Brand42
 *
 * @wordpress-plugin
 * Plugin Name:       Brand42
 * Plugin URI:        https://www.agence42.fr
 * Description:       Overloads the Elementor plugin for simpler use
 * Version:           1.2.0
 * Author:            SAHEB-JAMII Soheil
 * Author URI:        https://anym.fr
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       brand42
 * Domain Path:       /languages
 */

// If this file is called directly, abort.

if ( ! defined( 'WPINC' ) ) {
  die;
}

const BRAND42_VERSION = '1.2.0';
const BRAND42_NAME = 'Brand42';
const BRAND42_SLUG = 'brand42';
define('BRAND42_URL', plugin_dir_url(__FILE__));
define('BRAND42_DIR', plugin_dir_path(__FILE__));
const BRAND42_ASSETS = BRAND42_URL . 'assets';
const BRAND42_TAG = '[BRAND42] ';
const AGENCE42_URL = 'https://agence42.fr';

/**
 * Brand42 Plugin Class
 */
class Brand42Plugin {
  public array $modules = [
    //'AdminUrl', // Not working
    'CleanDashboard',
    'ColorScheme',
    'DashboardWidgets',
    'Crons',
    'Tools',
    'OptionsPage',
    'Roles',
	  'GenericAccount'
  ];

  public function __construct() {
    $this->load_plugin();
  }

  /**
   * Load the plugin
   * @return void
   */
  private function load_plugin(): void {
    require_once "includes/class-enqueue-assets.php";
    new Brand42\Includes\EnqueueAssets();

    require_once "includes/class-update-checker.php";
    new Brand42\Includes\UpdateChecker();

    require_once "modules/class-module-instancier.php";
    new Brand42\Modules\ModuleInstancier($this->modules);
  }
}



/**
 * Console log for debug
 * @param mixed $data - The data to log
 */
if( !function_exists('console') ) {
  function console(...$data): void {
    echo '<script>';
    $consoleData = [];
    foreach ($data as $d) {
      if (is_array($d) || is_object($d)) {
        $consoleData[] = json_encode($d, JSON_HEX_TAG);
      } else {
        $consoleData[] = '"'.$d . '"';
      }
    }
    echo 'console.log('.implode(',', $consoleData).')';
    //echo 'console.log("OK")';
    echo '</script>';
  }
}

// Delete role
new Brand42Plugin();