<?php
namespace Brand42\Modules;

use JetBrains\PhpStorm\NoReturn;

if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly.
}

/**
 * Tools Module
 *
 * @package Tools\Modules
 */
class Tools {
  public function __construct() {
    // Add buttons to admin bar
    add_action('admin_bar_menu', [$this, 'add_admin_bar_buttons'], 999);
    add_action( 'admin_post_brand42-reset-cache', [$this, 'post_reset_cache'], 0 );
  }

  public function add_admin_bar_buttons(): void {
    // If WP_Migrate plugin is active, add a button to the admin bar
    if (current_user_can('manage_options') && class_exists('DeliciousBrains\WPMDB\WPMigrateDB')){
      global $wp_admin_bar;
      $wp_admin_bar->add_menu([
        'id' => 'wp-migrate-db-pro',
        'title' => 'WP Migrate',
        'href' => admin_url('admin.php?page=wp-migrate-db-pro'),
        'meta' => [
          'title' => 'WP Migrate'
        ]
      ]);
    }

    // If Elementor plugin is active, add a "Reset Styles" button to the admin bar
    if (current_user_can('manage_options') && class_exists('Elementor\Plugin')){
      global $wp_admin_bar;
      $wp_admin_bar->add_menu([
        'id' => 'brand42-elementor-clear-cache-button',
        'title' => 'Reset CSS',
        'href' => admin_url('admin.php?page=elementor-tools'),
      ]);
    }

    // If WP_Rocket plugin is active, add a "Clear Cache" button to the admin bar
    if ((current_user_can('manage_options') || current_user_can('reset_cache')) && class_exists('WP_Rocket\Plugin')){
      global $wp_admin_bar;
      $href = admin_url('admin-post.php?action=brand42-reset-cache&_wp_http_referer=' . urlencode($_SERVER['REQUEST_URI']) . 'index.php&_wpnonce=' . wp_create_nonce('brand42_clear_cache'));
      $wp_admin_bar->add_menu([
        'id' => 'wp-rocket-clear-cache',
        'title' => 'Renouveler le Cache',
        'href' => $href,
      ]);
    }
  }

  #[NoReturn] public function post_reset_cache() {
    if (empty($_GET['_wpnonce'])) {
      wp_die('Missing nonce', 400);
    }
    if (!current_user_can('manage_options') && !current_user_can('reset_cache')) {
      wp_die('Unauthorized', 403);
    }
    if (!wp_verify_nonce($_GET['_wpnonce'], 'brand42_clear_cache')) {
      wp_die('Invalid nonce', 400);
    }
    if (function_exists('rocket_clean_domain' )) {
      rocket_clean_domain();

      // Redirect to the previous page
      wp_safe_redirect(wp_get_referer());
    }
    exit;
  }
}