<?php
namespace Brand42\Modules;

if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly.
}

/**
 * OptionsPage Module
 *
 * @package OptionsPage\Modules
 */
class OptionsPage {
  public function __construct() {
    // Add options page (to settings menu)
    add_action('admin_menu', [$this, 'add_options_page']);

    // Load settings
    $this->load_settings();
  }

  public function add_options_page(): void {
    add_options_page(
      'Brand42 Options',
      'Brand42 Options',
      'manage_options',
      'brand42-options',
      [$this, 'options_page_content'],
      'dashicons-admin-generic',
      99
    );
  }

  public function options_page_content(): void {
    ?>
    <div class="wrap">
      <h1>Brand42 Options</h1>
      <form method="post" action="options.php">
        <?php
        settings_fields('brand42_options');
        do_settings_sections('brand42_options');
        submit_button();
        ?>
      </form>
    </div>
    <?php
  }

  private function load_settings(): void {
    require __DIR__ . '/base-settings.php';

    require __DIR__ . '/class-general-settings.php';
    new OptionsPage\GeneralSettings();

    /*require __DIR__ . '/class-social-settings.php';
    new OptionsPage\SocialSettings();

    require __DIR__ . '/class-advanced-settings.php';
    new OptionsPage\AdvancedSettings();*/

    do_action('brand42/load_settings');
  }
}