<?php
namespace Brand42\Modules\DashboardWidgets;

if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly.
}

/**
 * Stats Widget
 *
 * @package Brand42\Modules\DashboardWidgets
 */
class FormEvolution extends DashboardBaseWidget {

  public function __construct() {
    parent::__construct();
  }

  public function get_title(): string {
    return 'Demande d\'évolution du site';
  }

  public function get_name(): string {
    return 'brand42_form-evolution_widget';
  }

  public function get_context(): string {
    return 'column3';
  }

  protected function render(): void {
    echo '<h3>Vous souhaitez faire évoluer votre site ?</h3>';
    echo '<form class="flex-column gap-10" action="#" method="post">';
    echo '<label for="evolution_description">Décrivez-nous ce que vous aviez en tête</label>';
    echo '<textarea name="evolution_description" rows="5" id="evolution_description" required></textarea>';
    echo '<button type="submit" class="a42-button">Envoyer</button>';
    echo '</form>';
    if ($_SERVER["REQUEST_METHOD"] == "POST") {
      $evolution_description = $_POST['evolution_description'];

      // Send mail
      $to = 'hebergement@agence42.fr, support@agence42.fr';
      $from = 'site@' . $_SERVER['SERVER_NAME'];
      $subject = 'Nouvelle demande d\'évolution de site';
      $website = get_bloginfo('name');
      $message = '<h1>Nouvelle demande d\'évolution de site</h1>';
      $message .= '<b>Site concerné : </b>' . $website;
      $message .= '<h2>Description de l\'évolution souhaitée :</h2>' . $evolution_description;

      $message .= '<hr>';
      $message .= '<small>Cette demande a été envoyée depuis le site ' . $website . ' (' . $_SERVER['SERVER_NAME'] . ').</small>';
      $headers = [
        'From: ' . $website . ' <' . $from . '>',
        'Content-Type: text/html; charset=UTF-8'
      ];

      $mail_sent = wp_mail($to, $subject, $message, $headers);

      // Check if mail was sent successfully
      if ($mail_sent) {
        echo '<p>Votre demande a été envoyée avec succès. Nous vous contacterons bientôt.</p>';
      } else {
        echo '<p>Une erreur est survenue lors de l\'envoi du formulaire. Veuillez réessayer plus tard.</p>';
      }
    }
  }
}