<?php
namespace Brand42\Modules\Crons;

if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly.
}

/**
 * BaseCron Class
 *
 * @package Brand42\Modules\Crons
 */
abstract class BaseCron {
  public function __construct() {
    add_action('init', [$this, 'schedule_cron']);
    add_action($this->get_name(), [$this, 'run_job']);
  }

  public function schedule_cron(): void {
    // Remove the schedule
    if ( ! wp_next_scheduled( $this->get_name() ) ) {
      wp_schedule_event( time(), $this->get_schedule(), $this->get_name() );
    }
  }

  public abstract function get_schedule(): string;

  public abstract function get_name(): string;

  public function run_job(): void {
    $this->job();
  }

  protected abstract function job(): void;
}